﻿Imports System.Net.Mail.MailAddress
Public Class clsValidator

    Private sError As String    'Hold any errors generated by this class
    Public Sub checkString(s As String, n As String)
        isValidString(s, n)
    End Sub
    Public Sub checkInt(ByVal i As String, n As String)
        isValidInt(i, n)
    End Sub
    Public Sub checkPhone(ByVal s As String, n As String)
        isValidPhone(s, n)
    End Sub
    Public Sub checkEmail(ByVal s As String, n As String)
        isValidEmail(s, n)
    End Sub
    Public Sub clearError()
        sError = ""
    End Sub
    Private Sub addError(ByVal s As String)
        'private function to format our error message by
        'adding line breaks when necessary
        If sError = "" Then
            sError = s
        Else
            sError += vbCrLf & s
        End If
    End Sub
    Public Function getError()
        'public Function to return the error to other objects
        Return sError
    End Function
    Private Function isValidString(s As String, n As String) As Boolean
        Dim bResult As Boolean
        Try
            If Len(s) > 0 Then
                bResult = True
            Else
                addError(n & " cannot be blank")
                bResult = False
            End If
        Catch ex As Exception
            addError("Invalid Entry (" & ex.Message & ")")
            bResult = False
        End Try
        Return bResult
    End Function
    Private Function isValidInt(s As String, n As String) As Boolean
        Dim bResult As Boolean
        Try
            If isValidString(s, n) Then
                If CInt(s) >= 0 Then
                    bResult = True
                Else
                    addError(n & " must be a number greater than 0")
                    bResult = False
                End If
            End If
        Catch ex As Exception
            addError("Invalid Entry (" & ex.Message & ")")
            bResult = False
        End Try
        Return bResult
    End Function
    Private Function isValidEmail(s As String, n As String) As Boolean
        Dim bResult As Boolean
        If isValidString(s, n) Then
            Try
                Dim address = New System.Net.Mail.MailAddress(s)
                bResult = True
            Catch ex As Exception
                addError("Invalid Email Address")
                bResult = False
            End Try
        End If
        Return bResult
    End Function
    Private Function isValidPhone(s As String, n As String) As Boolean
        Dim bResult As Boolean
        Try
            If CInt(s) > 0 Then
                If Len(s) = 10 Then
                    bResult = True
                Else
                    addError(n & " must be 10 digits")
                    bResult = False
                End If
            Else
                addError(n & " must be a number")
                bResult = False
            End If
        Catch ex As Exception
            addError("Invalid Entry: " & ex.Message)
            bResult = False
        End Try
        Return bResult
    End Function
End Class